#!/bin/sh
# $Id$

#       -----         -----         
#      /     \       /     \       /
#     /       \     /       \     /
#-----         -----         -----
#     \       /     \       /     \
#      \     /       \     /       \
#       -----         ----- detLFS  -
#      /     \       /     \       /
#     /       \     /       \     /
#-----         -----         -----
#http://www.dettus.net/detLFS

# The purpose of this script is to cross-compile packages
# Hopefully, the previous scripts are finished at this point

export DETLFSROOT=`pwd`
export TOOLSDIR=`pwd`/Tools
export DOWNLOADSDIR=`pwd`/Downloads
export DESTINATIONDIR=`pwd`/Destination
export SOURCESDIR=`pwd`/Sources



export DESTDIR=$DESTINATIONDIR
export PATH=$TOOLSDIR/bin:$PATH
export CROSS_COMPILE=$TOOLSDIR/bin/arm-linux-gnueabihf-

mkdir -p $SOURCESDIR/build

echo ">>> building BINUTILS"
(
	cd $SOURCESDIR/build/
	tar xvfz $DOWNLOADSDIR/binutils-2.26.1.tar.gz	
	cd binutils-2.26.1
	export CROSS_COMPILE=$TOOLSDIR/bin/arm-linux-gnueabihf-
	mkdir build-cross ; cd build-cross
	../configure --target=arm-linux-gnueabihf --host=arm-linux-gnueabihf --prefix=/usr --with-sysroot --disable-nls --disable-werror
	echo ">>>>>"
	make -j 8
	make install
)

echo ">>> installing glibc (for real)"
(
	cd $SOURCESDIR/build/
	tar xvfJ $DOWNLOADSDIR/glibc-2.23.tar.xz
	cd glibc-2.23
	mkdir build-cross ; cd build-cross
	../configure --host=arm-linux-gnueabihf --prefix=/ --with-headers=$DESTINATIONDIR/usr/include
	echo ">>>>>"
	make -j 8 cross-compiling=yes
	make -j 8 cross-compiling=yes  install
	make install
)

echo ">>> installing glibc (again)"
(
	cd $SOURCESDIR/build/
	tar xvfJ $DOWNLOADSDIR/glibc-2.23.tar.xz
	cd glibc-2.23
	mkdir build2-cross ; cd build2-cross
	../configure --host=arm-linux-gnueabihf --prefix=/arm-linux-gnueabihf/ --with-headers=$DESTINATIONDIR/usr/include
	echo ">>>>>"
	make -j 8 cross-compiling=yes
	make -j 8 cross-compiling=yes  install
	make install
)

####echo ">>> building gcc"
####(
####	cd $SOURCESDIR/build
####	tar xvfz $DOWNLOADSDIR/gcc-5.4.0.tar.gz
####	cd gcc-5.4.0
####	tar xvfJ $DOWNLOADSDIR/mpfr-3.1.4.tar.xz ; mv mpfr-3.1.4 mpfr
####	tar xvfJ $DOWNLOADSDIR/gmp-6.1.1.tar.xz ; mv gmp-6.1.1 gmp
####	tar xvfz $DOWNLOADSDIR/mpc-1.0.3.tar.gz ; mv mpc-1.0.3 mpc
####	mkdir build-cross ; cd build-cross
####	../configure --prefix=/usr --target=arm-linux-gnueabihf --host=arm-linux-gnueabihf --enable-languages=c,c++ --with-float=hard  --with-build-sysroot=$DESTINATIONDIR
####	make -j 8 all-gcc && make -j 8 all-target-libgcc && make install-gcc && make install-target-libgcc
####	
####)
echo ">>> building gcc (arm->arm)"
(
	cd $SOURCESDIR/build
	tar xvfz $DOWNLOADSDIR/gcc-5.4.0.tar.gz
	cd gcc-5.4.0
	tar xvfJ $DOWNLOADSDIR/mpfr-3.1.4.tar.xz ; mv mpfr-3.1.4 mpfr
	tar xvfJ $DOWNLOADSDIR/gmp-6.1.1.tar.xz ; mv gmp-6.1.1 gmp
	tar xvfz $DOWNLOADSDIR/mpc-1.0.3.tar.gz ; mv mpc-1.0.3 mpc
	mkdir build ; cd build
	../configure --target=arm-linux-gnueabihf --host=arm-linux-gnueabihf --disable-nls --enable-languages=c,c++ --disable-multilib 
	make -j 8 all-gcc && make -j 8 all-target-libgcc && make install-gcc && make install-target-libgcc
	echo ">>>>>"
	make -j 8
	make install
)

echo ">>> building gcc (arm->arm)"
(
	export CROSS_COMPILE=""
	cd $SOURCESDIR/build
	tar xvfz $DOWNLOADSDIR/gcc-5.4.0.tar.gz
	cd gcc-5.4.0
	tar xvfJ $DOWNLOADSDIR/mpfr-3.1.4.tar.xz ; mv mpfr-3.1.4 mpfr
	tar xvfJ $DOWNLOADSDIR/gmp-6.1.1.tar.xz ; mv gmp-6.1.1 gmp
	tar xvfz $DOWNLOADSDIR/mpc-1.0.3.tar.gz ; mv mpc-1.0.3 mpc
	mkdir build2 ; cd build2
	../configure --target=arm-linux-gnueabihf --host=arm-linux-gnueabihf --disable-nls --enable-languages=c,c++ --disable-multilib 
	make -j 8 all-gcc && make -j 8 all-target-libgcc && make install-gcc && make install-target-libgcc
	echo ">>>>>"
	make -j 8
	make install
)


