#!/bin/sh
# $Id$

#       -----         -----         
#      /     \       /     \       /
#     /       \     /       \     /
#-----         -----         -----
#     \       /     \       /     \
#      \     /       \     /       \
#       -----         ----- detLFS  -
#      /     \       /     \       /
#     /       \     /       \     /
#-----         -----         -----
#http://www.dettus.net/detLFS

# The purpose of this script is to create a bootable base system
# Hopefully, the previous scripts are finished at this point

export DETLFSROOT=`pwd`
export TOOLSDIR=`pwd`/Tools
export DOWNLOADSDIR=`pwd`/Downloads
export DESTINATIONDIR=`pwd`/Destination
export SOURCESDIR=`pwd`/Sources

mkdir -p $DESTINATIONDIR

export PATH=$TOOLSDIR/bin:$PATH

mkdir -p $DESTINATIONDIR
mkdir -p $SOURCESDIR/build/

echo ">>> building KERNEL (raspberry pi specific)"
(
	cd $SOURCESDIR/build/
	tar xvfJ $DOWNLOADSDIR/linux-4.4.15.tar.xz

	cd linux-4.4.15
	export KERNEL=kernel7
	convert $DETLFSROOT/logo/mylogo.xpm -scale \!80x80 /tmp/mylogo.png
	pngtopnm /tmp/mylogo.png | ppmquant 224 | pnmnoraw >drivers/video/logo/logo_linux_clut224.ppm
	make ARCH=arm CROSS_COMPILE=$TOOLSDIR/bin/arm-linux-gnueabihf- bcm2709_defconfig
#	vimdiff .config $DETLFSROOT/config_kernel
#	make ARCH=arm menuconfig
	cp $DETLFSROOT/config_kernel .config
	echo ">>>>>"
	make ARCH=arm CROSS_COMPILE=$TOOLSDIR/bin/arm-linux-gnueabihf- zImage modules dtbs -j 8
	mkdir -p $DESTINATIONDIR/boot $DESTINATIONDIR/usr
	echo ">>>>>"
	make ARCH=arm CROSS_COMPILE=$TOOLSDIR/bin/arm-linux-gnueabihf- INSTALL_MOD_PATH=$DESTINATIONDIR/ INSTALL_HDR_PATH=$DESTINATIONDIR/usr/ modules_install headers_install
	cp arch/arm/boot/zImage $DESTINATIONDIR/boot/kernel.img
	cp arch/arm/boot/dts/*.dtb $DESTINATIONDIR/boot
	mkdir -p $DESTINATIONDIR/boot/overlays
	cp arch/arm/boot/dts/overlays/*.dtb $DESTINATIONDIR/boot/overlays
	cp arch/arm/boot/dts/overlays/README $DESTINATIONDIR/boot/overlays
)

echo ">>> building BUSYBOX"
(
	date
	cd $SOURCESDIR/build
	tar xvfj $DOWNLOADSDIR/busybox-1.25.0.tar.bz2
	cd busybox-1.25.0/
	echo ">>>>>"
   	make ARCH=arm CROSS_COMPILE=$TOOLSDIR/bin/arm-linux-gnueabihf- defconfig
# 	vimdiff .config ../../../config_busybox
#   	make ARCH=arm menuconfig
	cp $DETLFSROOT/config_busybox .config
   	make ARCH=arm CROSS_COMPILE=$TOOLSDIR/bin/arm-linux-gnueabihf- install -j 8
	cd _install
	tar cvf - * | ( cd $DESTINATIONDIR ; tar xvf - )
	date
)



echo ">>> copying skeldir/"
(
	cd skeldir
	tar cvf - * | ( cd $DESTINATIONDIR ; tar xvf - )
)
echo ">>> copying raspberry specific bootloader files"
(
	cp $DOWNLOADSDIR/start.elf $DOWNLOADSDIR/bootcode.bin $DESTINATIONDIR/boot/
)

du -sh $DESTINATIONDIR
echo ">>>>"
