#!b/in/sh
# $Id$

#       -----         -----         
#      /     \       /     \       /
#     /       \     /       \     /
#-----         -----         -----
#     \       /     \       /     \
#      \     /       \     /       \
#       -----         ----- detLFS  -
#      /     \       /     \       /
#     /       \     /       \     /
#-----         -----         -----
#http://www.dettus.net/detLFS

# The purpose of this script is to build the cross compiler to be used later
# Hopefully, the previous scripts are finished at this point





export TOOLSDIR=`pwd`/Tools
export DOWNLOADSDIR=`pwd`/Downloads

mkdir -p $TOOLSDIR

export PATH=$TOOLSDIR/bin:$PATH



mkdir -p $TOOLSDIR/build/
echo ">>> installing Kernel Headers"
(
	cd $TOOLSDIR/build
	tar xvfJ $DOWNLOADSDIR/linux-4.4.15.tar.xz
	echo ">>>"
	cd linux-4.4.15
	mkdir -p $TOOLSDIR/usr/include/asm
	make -j 8 ARCH=arm INSTALL_HDR_PATH=$TOOLSDIR/usr headers_install  
)

echo ">>> installing glibc headers"
(
	cd $TOOLSDIR/build/
	tar xvfJ $DOWNLOADSDIR/glibc-2.23.tar.xz
	echo ">>>"
	cd glibc-2.23
	mkdir build ; cd build
	CC=gcc NM=nm ../configure --host=arm-linux-gnueabihf --prefix=$TOOLSDIR/ --with-headers=$TOOLSDIR/usr/include
	make -j 8 -k cross-compiling=yes install-headers  
	mkdir -p $TOOLSDIR/include/gnu/
	touch $TOOLSDIR/include/gnu/stubs.h
)
echo ">>> installing glibc headers"
(
	cd $TOOLSDIR/build/
	tar xvfJ $DOWNLOADSDIR/glibc-2.23.tar.xz
	echo ">>>"
	cd glibc-2.23
	mkdir build2 ; cd build2
	CC=gcc NM=nm ../configure --host=arm-linux-gnueabihf --prefix=$TOOLSDIR/arm-linux-gnueabihf/ --with-headers=$TOOLSDIR/usr/include
	make -j 8 -k cross-compiling=yes install-headers  
	mkdir -p $TOOLSDIR/arm-linux-gnueabihf/include/gnu/
	touch $TOOLSDIR/arm-linux-gnueabihf/include/gnu/stubs.h
)
echo ">>> building binutils (cross)"
(
	cd $TOOLSDIR/build/
	tar xvfz $DOWNLOADSDIR/binutils-2.26.1.tar.gz
	echo ">>>"
	cd binutils-2.26.1
	mkdir build-cross ; cd build-cross
	../configure --target=arm-linux-gnueabihf --prefix=$TOOLSDIR --with-sysroot --disable-nls --disable-werror
	make  -j 8 && make DESTDIR="" install
)
echo ">>> building gcc (cross)"
(
	cd $TOOLSDIR/build
	tar xvfz $DOWNLOADSDIR/gcc-5.4.0.tar.gz
	echo ">>>"
	cd gcc-5.4.0
	tar xvfJ $DOWNLOADSDIR/mpfr-3.1.4.tar.xz ; mv mpfr-3.1.4 mpfr
	tar xvfJ $DOWNLOADSDIR/gmp-6.1.1.tar.xz ; mv gmp-6.1.1 gmp
	tar xvfz $DOWNLOADSDIR/mpc-1.0.3.tar.gz ; mv mpc-1.0.3 mpc
	mkdir build-cross ; cd build-cross
	../configure --target=arm-linux-gnueabihf --prefix=$TOOLSDIR --disable-nls --disable-shared --enable-languages=c,c++ --disable-multilib --with-headers=$TOOLSDIR/usr/include --with-build-time-tools=$TOOLSDIR --with-build-sysroot=$TOOLSDIR
	echo ">>>"
	make -j 8 all-gcc && make -j 8 all-target-libgcc && make install-gcc && make install-target-libgcc

)

export PATH=$TOOLSDIR/bin:$TOOLSDIR/usr/bin:$PATH
echo ">>> installing glibc (for real)"
(
	cd $TOOLSDIR/build/
	tar xvfJ $DOWNLOADSDIR/glibc-2.23.tar.xz
	echo ">>>"
	cd glibc-2.23
	mkdir build-cross ; cd build-cross
	../configure --host=arm-linux-gnueabihf --prefix=$TOOLSDIR --with-headers=$TOOLSDIR/usr/include
	echo ">>>"
	make -j 8 cross-compiling=yes
	make -j 8 cross-compiling=yes  install
	make install
)

echo ">>> installing glibc (for the build)"
(
	cd $TOOLSDIR/build/
	tar xvfJ $DOWNLOADSDIR/glibc-2.23.tar.xz
	echo ">>>"
	cd glibc-2.23
	mkdir build2-cross ; cd build2-cross
	../configure --host=arm-linux-gnueabihf --prefix=$TOOLSDIR/arm-linux-gnueabihf/ --with-headers=$TOOLSDIR/usr/include
	echo ">>>"
	make -j 8 cross-compiling=yes
	make -j 8 cross-compiling=yes  install
	make install
)
echo ">>> building gcc (with shared)"
(
	cd $TOOLSDIR/build
	tar xvfz $DOWNLOADSDIR/gcc-5.4.0.tar.gz
	echo ">>>"
	cd gcc-5.4.0
	tar xvfJ $DOWNLOADSDIR/mpfr-3.1.4.tar.xz ; mv mpfr-3.1.4 mpfr
	tar xvfJ $DOWNLOADSDIR/gmp-6.1.1.tar.xz ; mv gmp-6.1.1 gmp
	tar xvfz $DOWNLOADSDIR/mpc-1.0.3.tar.gz ; mv mpc-1.0.3 mpc
	mkdir build2-cross ; cd build2-cross
	../configure --target=arm-linux-gnueabihf --prefix=$TOOLSDIR --disable-nls --enable-languages=c,c++ --disable-multilib --with-headers=$TOOLSDIR/usr/include --with-build-time-tools=$TOOLSDIR
	echo ">>>"
	make -j 8 all-gcc && make -j 8 all-target-libgcc && make install-gcc && make install-target-libgcc
	make -j 8
	make install
)


echo "Checking the Tools"
$TOOLSDIR/bin/arm-linux-gnueabihf-gcc -o Helloworld.app helloworld.c
file Helloworld.app
echo ">>>>>>>> done"
