#!/bin/sh
# $Id$

#       -----         -----         
#      /     \       /     \       /
#     /       \     /       \     /
#-----         -----         -----
#     \       /     \       /     \
#      \     /       \     /       \
#       -----         ----- detLFS  -
#      /     \       /     \       /
#     /       \     /       \     /
#-----         -----         -----
#http://www.dettus.net/detLFS

# This script is downloading the packages prior to anything else.
# The kernel is being downloaded from the Raspberry Github, since
# this is the platform I plan on running everything on.





export DOWNLOADSDIR=`pwd`/Downloads
mkdir -p $DOWNLOADSDIR



wget --directory-prefix=$DOWNLOADSDIR -c https://busybox.net/downloads/busybox-1.25.0.tar.bz2
wget --directory-prefix=$DOWNLOADSDIR -c ftp://ftp.gnu.org/gnu/binutils/binutils-2.26.1.tar.gz
wget --directory-prefix=$DOWNLOADSDIR -c ftp://ftp.gnu.org/gnu/glibc/glibc-2.23.tar.xz
wget --directory-prefix=$DOWNLOADSDIR -c ftp://ftp.gnu.org/gnu/gmp/gmp-6.1.1.tar.xz
wget --directory-prefix=$DOWNLOADSDIR -c ftp://ftp.gnu.org/gnu/mpfr/mpfr-3.1.4.tar.xz
wget --directory-prefix=$DOWNLOADSDIR -c ftp://ftp.gnu.org/gnu/mpc/mpc-1.0.3.tar.gz
#wget --directory-prefix=$DOWNLOADSDIR -c ftp://gcc.gnu.org/pub/gcc/infrastructure/isl-0.16.1.tar.bz2
wget --directory-prefix=$DOWNLOADSDIR -c ftp://ftp.gnu.org/gnu/gcc/gcc-5.4.0/gcc-5.4.0.tar.gz
#wget --directory-prefix=$DOWNLOADSDIR -c https://cdn.kernel.org/pub/linux/kernel/v4.x/linux-4.4.15.tar.xz
wget --directory-prefix=$DOWNLOADSDIR -c ftp://ftp.gnu.org/pub/gnu/binutils/binutils-2.26.1.tar.gz
wget --directory-prefix=Downloads/ -c ftp://ftp.gnu.org/gnu/make/make-4.2.1.tar.gz


echo "The next packages are going to be Raspberry Pi specific."
(
	cd $DOWNLOADSDIR
	git clone --depth=1 https://github.com/raspberrypi/linux
	rm -rf linux/.git
	mv linux linux-4.4.15
	tar cvfJ linux-4.4.15.tar.xz linux-4.4.15
)
wget -O $DOWNLOADSDIR/bootcode.bin  "https://raw.githubusercontent.com/raspberrypi/firmware/master/boot/bootcode.bin"
wget -O $DOWNLOADSDIR/start.elf "https://raw.githubusercontent.com/raspberrypi/firmware/master/boot/start.elf"

