#!/bin/sh

mkdir -p tmp
for I in graphics_vmode_*.xpm
do 
	convert $I -crop 2007x1685+0+50 tmp/$I
done
montage 	-pointsize 150 \
-label "none"		tmp/graphics_vmode_none.xpm 	\
-label "monochrome"	tmp/graphics_vmode_monochrome.xpm \
-label "low_ansi"	tmp/graphics_vmode_low_ansi.xpm \
-label "low_ansi2"	tmp/graphics_vmode_low_ansi2.xpm \
-label "high_ansi"	tmp/graphics_vmode_high_ansi.xpm \
-label "high_ansi2"	tmp/graphics_vmode_high_ansi2.xpm \
-label "utf"		tmp/graphics_vmode_utf.xpm \
-label "sixel"		tmp/graphics_vmode_sixel.xpm \
-geometry 2007x1685+150+20 -tile 2x4 -strip -colors 512 tmp/graphics_modes.png
convert tmp/graphics_modes.png -strip graphics_modes.png
convert graphics_modes.png -scale 810x1123 -quality 60 graphics_modes.jpg

montage -pointsize 150 \
-label "1024x768" graphics_vmode_sixel1024x768.png \
-label "800x600" graphics_vmode_sixel800x600.png \
-label "640x480" graphics_vmode_sixel640x480.png \
-label "320x240" graphics_vmode_sixel320x240.png \
-geometry 2007x1685+10+10 -tile 2x2 -strip -colors 512 tmp/graphics_sixels.png
convert tmp/graphics_sixels.png -scale 1003x842 -colors 64 -strip graphics_sixels.png
