#!/bin/sh

mkdir -p tmp
for I in graphics_vmode_*.xpm
do 
	convert $I -crop 2007x1685+0+50 tmp/$I
done
montage 	-pointsize 150 \
-label "none"		tmp/graphics_vmode_none.xpm 	\
-label "low_ansi"	tmp/graphics_vmode_low_ansi.xpm \
-label "monochrome"	tmp/graphics_vmode_monochrome.xpm \
-label "high_ansi"	tmp/graphics_vmode_high_ansi.xpm \
-label "sixel"		tmp/graphics_vmode_sixel.xpm \
-label "high_ansi2"	tmp/graphics_vmode_high_ansi2.xpm \
-geometry 2007x1685+10+20 -tile 2x3 -strip -colors 512 tmp/graphics_modes.png
convert tmp/graphics_modes.png -strip graphics_modes.png

montage -pointsize 150 \
-label "1024x768" graphics_vmode_sixel1024x768.png \
-label "800x600" graphics_vmode_sixel800x600.png \
-label "640x480" graphics_vmode_sixel640x480.png \
-label "320x240" graphics_vmode_sixel320x240.png \
-geometry 2007x1685+10+10 -tile 2x2 -strip -colors 512 tmp/graphics_sixels.png
convert tmp/graphics_sixels.png -scale 1003x842 -colors 64 -strip graphics_sixels.png
